#!/bin/bash


total_mem=`free -m |grep 'Mem' |awk -F' ' '{print $2}'`
: '
if total_mem <= 8G:
    heap_size = 2 * 1024 MB
elif total_mem <= 12G:
    heap_size = 2.5 * 1024 MB
elif total_mem <= 16G:
    heap_size = 3 * 1024 MB
else
    heap_size = 4 * 1024 MB
'
if [ ${total_mem} -le 8192 ];then
    self_mem="2048m"
elif [ ${total_mem} -le 12288 ];then
    self_mem="2560m"
elif [ ${total_mem} -le 16384 ];then
    self_mem="3072m"
else
    self_mem="4096m"
fi

sed -i "s/^-Xms.*/-Xms${self_mem}/g" /etc/elasticsearch/jvm.options
sed -i "s/^-Xmx.*/-Xmx${self_mem}/g" /etc/elasticsearch/jvm.options
